﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TMPro;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class PlayerOneState : RoleSelectState
{
    public override void OnStartCurrentState()
    {
        //Hide the mask, show the content
        RoleSelect.PlayerOne.FindChild("Mask").SetActive(false);
        RoleSelect.PlayerOne.FindChild("Content").Enable();

        //Player one state, so show Player Two's mask and disable the content
        RoleSelect.PlayerTwo.FindChild("Mask").FindChild("MaskText").GetComponent<TMP_Text>().SetText("WAITING FOR PLAYER 1");
        RoleSelect.PlayerTwo.FindChild("Mask").SetActive(true);
        RoleSelect.PlayerTwo.FindChild("Content").Disable();

        PageManager.CurrentPage.DefaultFocusedControl = RoleSelect.PlayerOne.FindChild("Content").FindChild("CharacterSelector").GetComponent<Selectable>();
        EventSystem.current.SetSelectedGameObject(PageManager.CurrentPage.DefaultFocusedControl.gameObject);
    }

    public override void OnEndCurrentState()
    {
        //This state is ending so Player One is ready
        RoleSelect.PlayerOne.FindChild("Mask").FindChild("MaskText").GetComponent<TMP_Text>().SetText("READY");
        RoleSelect.PlayerOne.FindChild("Mask").SetActive(true);
        RoleSelect.PlayerOne.FindChild("Content").Disable();
    }

    public override void MoveToNextState()
    {
        //Moving onto Player Two
        RoleSelect.ChangeCurrentState(new PlayerTwoState());
    }

    public override void MoveToPreviousState()
    {
        //We're at the very first state so navigate the page back
        PageManager.NavigateBack();
    }
}

